
	if (typeof(tinymce) !== "undefined" ) {

		var current_editor;
		tinymce.PluginManager.add( 'aops_insert_cu', function( editor, url ) {

			// Add a button that opens a window
			editor.addButton( 'aops_insert_cu_button_key', {

				/* text: 'Insert Content Upgrade',*/
				title: 'Insert Content Upgrade',
				icon: 'icon dashicons-email-alt',
				onclick: function() {
					// Save editor id to insert text into in later
					current_editor = editor;

					// Open window
					if (typeof jQuery.fancybox2 === 'function') {
						jQuery.fancybox2.open(jQuery("#aops-content-upgrades-list"), {
							tpl			: {
								closeBtn : '<a title="Close" class="fancybox2-item fancybox2-close" style="top:-20px" href="javascript:;">&times;</a>'
							},
							helpers: {
								overlay: {
								  locked: false
								}
							}
						});
					}

				}

			} );

		});
	}

	// check for some plugins such as Simple Press Forum which add this script to the front-end
	// so other CU JS files may be not loaded. But they are not needed anyway in this case,
	// so we'll just skip this code
	if (typeof ZeroClipboardCU === 'function') {
		// implement copy to clipboard

		// 1) for 'Call-to-action Box'
		var call_box_copy_button = new ZeroClipboardCU( document.getElementById("aops_copy_shortcode_template") );
		// 2) for 'Insert a Link'
		var insert_link_copy_button = new ZeroClipboardCU( document.getElementById("aops_copy_link_template") );

		// 3)for shortcode template inside 'Insert CU' box
		var shortcode_copy_button = new ZeroClipboardCU( document.getElementById("aops-copy-shortcode") );
		// 4)for link template inside 'Insert CU' box
		var link_copy_button = new ZeroClipboardCU( document.getElementById("aops-copy-link") );

		// Notifications about copying
		call_box_copy_button.on( "ready", function( readyEvent ) {
			call_box_copy_button.on( "aftercopy", function( event ) {
				jQuery('#flash-message').html("<div>Copied</div>").fadeIn(500).fadeOut(1000);
			} );
		} );

		insert_link_copy_button.on( "ready", function( readyEvent ) {
			insert_link_copy_button.on( "aftercopy", function( event ) {
				jQuery('#flash-message').html("<div>Copied</div>").fadeIn(500).fadeOut(1000);
			} );
		} );

		shortcode_copy_button.on( "ready", function( readyEvent ) {
			shortcode_copy_button.on( "aftercopy", function( event ) {
				jQuery('#flash-message').html("<div>Copied</div>").fadeIn(500).fadeOut(1000);
			} );
		} );

		link_copy_button.on( "ready", function( readyEvent ) {
			link_copy_button.on( "aftercopy", function( event ) {
				jQuery('#flash-message').html("<div>Copied</div>").fadeIn(500).fadeOut(1000);
			} );
		} );


	}

	jQuery("#aops-content-upgrades-select").change(function(){
		var cuId = jQuery(this).val();

		var shortcodeTemplate = '[content_upgrade cu_id="{cuId}"]Get the bonus content: {cuTitle}[content_upgrade_button]Click Here[/content_upgrade_button][/content_upgrade]';
		var linkTemplate = '<a class="cu-popup" href="#cu_{cuId}">Get the bonus: {cuTitle}</a>';


		// Getting CU title from dropdown selected text
		var selectedText = jQuery("#aops-content-upgrades-select option:selected").text();
		var i = selectedText.indexOf(' ');
		var splits = [selectedText.slice(0,i), selectedText.slice(i+1)];

		var cuTitle = splits[1];

		var cuRegexp = new RegExp("cu_",'g');
		var titleRegexp = new RegExp("\{cuTitle\}",'g');
		var idRegexp = new RegExp("\{cuId\}",'g');


		cuId = cuId.replace(cuRegexp,'');
		shortcodeTemplate = shortcodeTemplate.replace(titleRegexp,cuTitle).replace(idRegexp,cuId);
		linkTemplate = linkTemplate.replace(titleRegexp,cuTitle).replace(idRegexp,cuId);


		if (typeof jQuery.fancybox2 === 'function') {jQuery.fancybox2.update(); }

		if (cuId != "0") {
			jQuery("#aops-copybox-shortcode").html(escapeHtml(shortcodeTemplate));
			jQuery("#aops-copy-shortcode").attr('data-clipboard-text',shortcodeTemplate);
			jQuery("#aops-insert-shortcode").attr('data-insert-text',shortcodeTemplate);

			jQuery("#aops-copybox-link").html(escapeHtml(linkTemplate));
			jQuery("#aops-copy-link").attr('data-clipboard-text',linkTemplate);
			jQuery("#aops-insert-link").attr('data-insert-text',linkTemplate);

			jQuery("#aops-content-upgrades-copybox").show();

		}
		else {
			jQuery("#aops-content-upgrades-copybox").hide();
		}

	});

	jQuery("#aops-insert-shortcode, #aops-insert-link").off("click").click(function(){

		var insertText = jQuery(this).attr('data-insert-text');
		current_editor.insertContent( insertText );

		if (typeof jQuery.fancybox2 === 'function') { jQuery.fancybox2.close(); }
	});
